﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace RevisionAnalyser.Projects.RecoderProject
{
    public partial class SelectPercentageForm : Form
    {
        private double _percentage = 10.0;

        public SelectPercentageForm(double percentage)
        {
            _percentage = percentage;
            InitializeComponent();
        }

        private void SelectPercentageForm_Load(object sender, EventArgs e)
        {
            uxTrackBar.Value = (int)Math.Floor(_percentage);
        }

        public int GetPercentage()
        {
            return uxTrackBar.Value;
        }

        private void uxCancelButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void uxOKButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }

        private void uxTrackBar_ValueChanged(object sender, EventArgs e)
        {
            uxPercentageLabel.Text = uxTrackBar.Value + "%";
        }
    }
}
